/*
 * Decompiled with CFR 0.152.
 */
package space.essem.image2map.gui;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import eu.pb4.mapcanvas.api.core.CanvasColor;
import eu.pb4.mapcanvas.api.core.CanvasImage;
import eu.pb4.mapcanvas.api.core.DrawableCanvas;
import eu.pb4.mapcanvas.api.font.DefaultFonts;
import eu.pb4.mapcanvas.api.utils.CanvasUtils;
import java.awt.image.BufferedImage;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2641;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import space.essem.image2map.Image2Map;
import space.essem.image2map.gui.MapGui;
import space.essem.image2map.renderer.MapRenderer;

public class PreviewGui
extends MapGui {
    private static final CommandDispatcher<PreviewGui> COMMANDS = new CommandDispatcher();
    private final BufferedImage sourceImage;
    private final String source;
    private boolean dirty;
    private int xPos;
    private CanvasImage image;
    private int yPos;
    private Image2Map.DitherMode ditherMode;
    private int width;
    private int height;
    private boolean grid = true;
    private CompletableFuture<CanvasImage> imageProcessing;

    public PreviewGui(class_3222 player, BufferedImage image, String source, Image2Map.DitherMode ditherMode, int width, int height) {
        super(player, class_3532.method_15384((double)((double)width / 128.0)) + 2, class_3532.method_15384((double)((double)height / 128.0)) + 2);
        this.width = width;
        this.height = height;
        this.ditherMode = ditherMode;
        this.source = source;
        this.sourceImage = image;
        player.field_13987.method_14364((class_2596)new class_2641(COMMANDS.getRoot()));
        this.updateImage();
    }

    protected void updateImage() {
        this.setDistance(Math.max((double)this.height / 128.0 * 0.8, (double)this.width / 128.0 * 0.5));
        this.dirty = true;
        this.drawLoading();
    }

    public void onTick() {
        if (this.dirty) {
            if (this.imageProcessing != null) {
                this.imageProcessing.cancel(true);
            }
            this.imageProcessing = CompletableFuture.supplyAsync(() -> MapRenderer.render(this.sourceImage, this.ditherMode, this.width, this.height));
            this.dirty = false;
        }
        if (this.imageProcessing != null && this.imageProcessing.isDone()) {
            if (this.imageProcessing.isCompletedExceptionally()) {
                this.imageProcessing = null;
            } else {
                try {
                    this.image = this.imageProcessing.get();
                    this.imageProcessing = null;
                    this.xPos = (this.canvas.getWidth() - this.image.getWidth()) / 2;
                    this.yPos = (this.canvas.getHeight() - this.image.getHeight()) / 2;
                    this.draw();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    this.close();
                }
            }
        }
    }

    @Override
    public void onClose() {
        if (this.imageProcessing != null) {
            this.imageProcessing.cancel(true);
        }
        super.onClose();
    }

    private void drawLoading() {
        String text = "Loading...";
        int size = (int)Math.min((double)this.height / 128.0, (double)this.width / 128.0) * 16;
        int width = DefaultFonts.VANILLA.getTextWidth(text, (double)size);
        CanvasUtils.fill((DrawableCanvas)this.canvas, (int)((this.width - width) / 2 - size + 128), (int)((this.height - size) / 2 - size + 128), (int)((this.width - width) / 2 + size + width + 128), (int)((this.height - size) / 2 + size * 2 + 128), (CanvasColor)CanvasColor.BLACK_LOW);
        DefaultFonts.VANILLA.drawText((DrawableCanvas)this.canvas, text, (this.width - width) / 2 + 128, (this.height - size) / 2 + 128, (double)size, CanvasColor.WHITE_HIGH);
        this.canvas.sendUpdates();
    }

    private void draw() {
        CanvasImage image = new CanvasImage(this.canvas.getWidth(), this.canvas.getHeight());
        if (this.grid) {
            for (int x = 0; x < this.canvas.getSectionsWidth(); ++x) {
                for (int y = 0; y < this.canvas.getSectionsHeight(); ++y) {
                    CanvasUtils.fill((DrawableCanvas)image, (int)(x * 128), (int)(y * 128), (int)((x + 1) * 128), (int)((y + 1) * 128), (CanvasColor)((x + y % 2) % 2 == 0 ? CanvasColor.BLACK_LOW : CanvasColor.GRAY_HIGH));
                }
            }
            CanvasUtils.fill((DrawableCanvas)image, (int)(this.xPos - 2), (int)(this.yPos - 2), (int)(this.xPos + 2 + this.image.getWidth()), (int)(this.yPos + 2 + this.image.getHeight()), (CanvasColor)CanvasColor.WHITE_HIGH);
        } else {
            CanvasUtils.clear((DrawableCanvas)image, (CanvasColor)CanvasColor.CLEAR_FORCE);
        }
        if (this.image != null) {
            CanvasUtils.draw((DrawableCanvas)image, (int)this.xPos, (int)this.yPos, (DrawableCanvas)this.image);
        }
        CanvasUtils.draw((DrawableCanvas)this.canvas, (int)0, (int)0, (DrawableCanvas)image);
        this.canvas.sendUpdates();
    }

    public void setSize(int width, int height) {
        if (this.canvas.getWidth() < width + 256 || this.canvas.getHeight() < height + 256 || this.canvas.getWidth() > width * 2 || this.canvas.getHeight() > height * 2) {
            this.resizeCanvas(class_3532.method_15384((double)((double)width / 128.0)) + 2, class_3532.method_15384((double)((double)height / 128.0)) + 2);
        }
        this.width = width;
        this.height = height;
        this.updateImage();
    }

    public void setDitherMode(Image2Map.DitherMode ditherMode) {
        this.ditherMode = ditherMode;
        this.updateImage();
    }

    public void setDrawGrid(boolean grid) {
        this.grid = grid;
        this.draw();
    }

    @Override
    public void executeCommand(String command) {
        try {
            COMMANDS.execute(command, (Object)this);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static LiteralArgumentBuilder<PreviewGui> literal(String name) {
        return LiteralArgumentBuilder.literal((String)name);
    }

    private static <T> RequiredArgumentBuilder<PreviewGui, T> argument(String name, ArgumentType<T> argumentType) {
        return RequiredArgumentBuilder.argument((String)name, argumentType);
    }

    static {
        COMMANDS.register((LiteralArgumentBuilder)PreviewGui.literal("exit").executes(x -> {
            ((PreviewGui)((Object)((Object)x.getSource()))).close();
            return 0;
        }));
        COMMANDS.register((LiteralArgumentBuilder)PreviewGui.literal("save").executes(x -> {
            if (((PreviewGui)((Object)((Object)x.getSource()))).imageProcessing == null) {
                ((PreviewGui)((Object)((Object)x.getSource()))).drawLoading();
                Image2Map.giveToPlayer((class_1657)((PreviewGui)((Object)((Object)x.getSource()))).player, MapRenderer.toVanillaItems(((PreviewGui)((Object)((Object)x.getSource()))).image, ((PreviewGui)((Object)((Object)x.getSource()))).player.method_14220(), ((PreviewGui)((Object)((Object)x.getSource()))).source), ((PreviewGui)((Object)((Object)x.getSource()))).source, ((PreviewGui)((Object)((Object)x.getSource()))).width, ((PreviewGui)((Object)((Object)x.getSource()))).height);
                ((PreviewGui)((Object)((Object)x.getSource()))).close();
            } else {
                ((PreviewGui)((Object)((Object)x.getSource()))).player.method_43496((class_2561)class_2561.method_43470((String)"Image is still processed!"));
            }
            return 0;
        }));
        COMMANDS.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)PreviewGui.literal("size").then(PreviewGui.argument("width", IntegerArgumentType.integer((int)1)).then(PreviewGui.argument("height", IntegerArgumentType.integer((int)1)).executes(x -> {
            ((PreviewGui)((Object)((Object)x.getSource()))).setSize(IntegerArgumentType.getInteger((CommandContext)x, (String)"width"), IntegerArgumentType.getInteger((CommandContext)x, (String)"height"));
            return 0;
        })))).executes(x -> {
            ((PreviewGui)((Object)((Object)x.getSource()))).player.method_43496((class_2561)class_2561.method_43470((String)("Source: " + ((PreviewGui)((Object)((Object)x.getSource()))).sourceImage.getWidth() + " x " + ((PreviewGui)((Object)((Object)x.getSource()))).sourceImage.getHeight())));
            ((PreviewGui)((Object)((Object)x.getSource()))).player.method_43496((class_2561)class_2561.method_43470((String)("MapImage: " + ((PreviewGui)((Object)((Object)x.getSource()))).width + " x " + ((PreviewGui)((Object)((Object)x.getSource()))).height)));
            return 0;
        }));
        COMMANDS.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)PreviewGui.literal("dither").then(PreviewGui.literal("none").executes(x -> {
            ((PreviewGui)((Object)((Object)x.getSource()))).setDitherMode(Image2Map.DitherMode.NONE);
            return 0;
        }))).then(PreviewGui.literal("floyd").executes(x -> {
            ((PreviewGui)((Object)((Object)x.getSource()))).setDitherMode(Image2Map.DitherMode.FLOYD);
            return 0;
        })));
        COMMANDS.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)PreviewGui.literal("grid").then(PreviewGui.argument("value", BoolArgumentType.bool()).executes(x -> {
            ((PreviewGui)((Object)((Object)x.getSource()))).setDrawGrid(BoolArgumentType.getBool((CommandContext)x, (String)"value"));
            return 0;
        }))).executes(x -> {
            ((PreviewGui)((Object)((Object)x.getSource()))).setDrawGrid(!((PreviewGui)((Object)((Object)x.getSource()))).grid);
            return 0;
        }));
    }
}

